////////////////////////////////////////////////////////////////////////////////
//	File	:	"CSGD_MessageSystem.h"
//
//	Author	:	Sean Murray
//
//	Purpose	:	The Message System for our application.  Handles sending the 
//				messages to the specified proc function.	
////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "Messages.h"
#include <queue>
using std::queue;



typedef void (*MESSAGEPROC)(CBaseMessage*);



class CSGD_MessageSystem
{
private:
	queue<CBaseMessage*>			m_MsgQueue;				//	Stores my messages.
	MESSAGEPROC						m_pfnMsgProc;			//	Points to user defined function.

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Constructor
	//
	//  Purpose : Creates the object.
	///////////////////////////////////////////////////////////////////////////////////
	CSGD_MessageSystem() { m_pfnMsgProc = NULL;	}
	CSGD_MessageSystem(const CSGD_MessageSystem&);
	CSGD_MessageSystem& operator=(const CSGD_MessageSystem&);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Destructor
	//
	//  Purpose : Cleans up any dynamic memory.
	///////////////////////////////////////////////////////////////////////////////////
	~CSGD_MessageSystem() {}
public:
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: GetInstance
	//
	//  Purpose : Gets an instance to the message system.
	///////////////////////////////////////////////////////////////////////////////////	
	static CSGD_MessageSystem* GetInstance(void);

		///////////////////////////////////////////////////////////////////////////////////
	//  Function: GetNumMessage
	//
	//  Purpose : Gets teh number of messages in the system.
	///////////////////////////////////////////////////////////////////////////////////
	inline int GetNumMessages(void) { return (int)m_MsgQueue.size(); }

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: InitMessageSystem
	//
	//  Purpose : Sets up a function pointer to the system.
	///////////////////////////////////////////////////////////////////////////////////
	void InitMessageSystem(MESSAGEPROC pfnMsgProc);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: SendMsg
	//
	//  Purpose : Sends a message to the system.
	///////////////////////////////////////////////////////////////////////////////////
	void SendMsg(CBaseMessage* pMsg);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: ProcessMessages
	//
	//  Purpose : Processes all messages in the queue.
	///////////////////////////////////////////////////////////////////////////////////
	void ProcessMessages(void);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: ShutdownMessageSystem
	//
	//  Purpose : Shuts down the message system.
	///////////////////////////////////////////////////////////////////////////////////
	void ShutdownMessageSystem(void);
};